capture log close
clear all
macro drop _all
*version 18
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\Five Outputs\Data Mgt"
set more off
log using m_DNSPopex24-5Out, replace text
*set scheme vg_s1c

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function
Author:  Michael Cunningham
File:    m_DNSPopex24-5Out
Initial Date:    3-Jul-2022
Revised Date:	 28-May-2025
--------------------------------------------------------------------------*/

tempfile nz ontario

* A. New Zealand DNSPs
*--------------------------------------------------------------------------

import excel "Quantonomics-AER-NZData-26May2025", clear ///
	sheet("NZ  ABR25") cellrange(A1:O362) firstrow case(l)
sort eiid year	
describe, fullnames

rename opex000 opex
rename rmdmw rmdem
rename customernumbers custnum
rename circuitlengthkm circlen
rename shareofundergroundcables shareugc
rename priceopexindex propex
rename energydelivered energy
rename unplannedsaidi SAIDI

replace energy = energy/1000

gen CMOS = SAIDI * custnum

drop maximumcoincidentsystemdemand undergroundlengthkm maximumdemandmw
order eiid dnspname year country opex propex rmdem custnum circlen shareugc
*tabmiss
describe

save `nz'
export excel "OpexFnData.xlsx", firstrow(var) keepcellfmt sheet("nz", replace)

* B. Ontario
*--------------------------------------------------------------------------

import excel "Ontario ABR25 Data -26May2025", clear ///
	sheet("Ontario ABR25") cellrange(A1:N552) firstrow case(l)
sort eiid year	
describe, fullnames
rename energydelivered energy
rename saidi_unplanned SAIDI
rename rmdemand rmdem 

replace energy = energy/1000000
gen CMOS = SAIDI * custnum

drop uglen maxdem 

replace dnspname = "Entegrus Powerlines" if dnspname == "Entegrus Powerlines Inc."

*tabmiss
describe

save `ontario'
export excel "OpexFnData.xlsx", firstrow(var) keepcellfmt sheet("ont", replace)

* C. Australia 
*--------------------------------------------------------------------------

use dnspbench24-firm, clear

gen int eiid = 1000 + dnsp
gen byte country = 1

rename price_opex propex
rename customers custnum
rename ucshare shareugc
rename ratchetmd rmdem
rename circlength circlen

decode dnsp, generate(name0)
split name0, parse(.) generate(name)
drop name0 name1
rename name2 name0
split name0, parse(": ") generate(name)
rename name2 dnspname
rename cmos CMOS
gen SAIDI = CMOS/custnum

sort eiid year
keep country eiid year opex propex rmdem custnum circlen shareugc ///
	dnspname energy CMOS SAIDI
order eiid dnspname year country opex propex rmdem custnum circlen shareugc
export excel "OpexFnData.xlsx", firstrow(var) keepcellfmt sheet("aus", replace)
	
* D. Append
*-----------------------------------------------------
	
append using `nz' `ontario'
sort eiid year

replace shareugc = 0.01 if shareugc < 0.01
label define country 1 "1.Aust" 2 "2.NZ" 3 "3.Ontario"
label values country country
labmask eiid, values(dnspname)	
drop dnspname

label variable opex  			"Operating expenditure (local currency, 000)"
label variable custnum			"Customers (#)"
label variable circlen			"Circuit length (km)"
label variable shareugc			"Underground cable: % of circuit length"
label variable rmdem 			"Ratcheted maximum demand (MW)"
label variable propex			"Opex price index (2005 = 1.0)"
label variable country			"Country code"
label variable eiid				"Utility code"
label variable year				"Reporting year"

tab1 country eiid
describe
summarize 

tabmiss
summarize CMOS if country == 1

replace CMOS = 4056448 if CMOS == 0

save DNSPopex24-5Out, replace

gen energyCL = energy/circlen
gen energycus = energy/custnum	
gen CMOSCL = CMOS/circlen
gen CMOScus = CMOS/custnum	




summ energy energyCL energycus CMOS CMOSCL CMOScus

preserve
collapse (mean) energyCL energycus energy CMOS CMOSCL CMOScus, by(country)
restore

*-----
preserve

collapse (mean) SAIDI, by(country year)

twoway ///
    line SAIDI year if country == 1, lcolor(blue) || ///
    line SAIDI year if country == 2, lcolor(red) || ///
    line SAIDI year if country == 3, lcolor(green) ///
    , legend(label(1 "AUS") label(2 "NZ") label(3 "Ontario")) ///
    xlabel(2005(2)2023) ///
    xtitle("Year") ///
    ytitle("Average SAIDI") ///
    xscale(range(2005 2023)) ///
    title("")

graph export "average_SAIDI_chart.png", replace

restore

preserve

collapse (mean) CMOS, by(country year)

twoway ///
    line CMOS year if country == 1, lcolor(blue) || ///
    line CMOS year if country == 2, lcolor(red) || ///
    line CMOS year if country == 3, lcolor(green) ///
    , legend(label(1 "AUS") label(2 "NZ") label(3 "Ontario")) ///
    xlabel(2005(2)2023) ///
    xtitle("Year") ///
    ylabel(, format(%15.0fc)) ///
	ytitle("Average CMOS") ///
    xscale(range(2005 2023)) ///
    title("")

graph export "average_CMOS_chart.png", replace

restore

preserve

collapse (mean) energy, by(country year)

twoway ///
    line energy year if country == 1, lcolor(blue) || ///
    line energy year if country == 2, lcolor(red) || ///
    line energy year if country == 3, lcolor(green) ///
    , legend(label(1 "AUS") label(2 "NZ") label(3 "Ontario")) ///
    xlabel(2005(2)2023) ///
    xtitle("Year") ///
    ylabel(, format(%15.0fc)) ///
	ytitle("Average energy") ///
    xscale(range(2005 2023)) ///
    title("")

graph export "average_energy_chart.png", replace

restore



	
log close
exit

